/*******************************************************************************
*
* Copyright (c) 2015-2017 Intel Corporation.  All rights reserved.
*
* This software is available to you under a choice of one of two
* licenses.  You may choose to be licensed under the terms of the GNU
* General Public License (GPL) Version 2, available from the file
* COPYING in the main directory of this source tree, or the
* OpenFabrics.org BSD license below:
*
*   Redistribution and use in source and binary forms, with or
*   without modification, are permitted provided that the following
*   conditions are met:
*
*    - Redistributions of source code must retain the above
*	copyright notice, this list of conditions and the following
*	disclaimer.
*
*    - Redistributions in binary form must reproduce the above
*	copyright notice, this list of conditions and the following
*	disclaimer in the documentation and/or other materials
*	provided with the distribution.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
* BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
* ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
*******************************************************************************/
/*$FreeBSD$*/

#ifndef	_IW_IXL_LINUX_WAIT_H_
#define	_IW_IXL_LINUX_WAIT_H_

/*
 * TODO: Content of this file should ultimately land in linux-kpi
 * (linux/wait.h file)
 */

#include <linux/wait.h>

#ifndef wait_event_timeout
/*
 * This is left for backward compatibility with FreeBSD 10.3 and 11.0
 */
#define	wait_event_timeout(q, cond, timeout)			\
({								\
	void *c = &(q).wchan;					\
	long end = jiffies + timeout;				\
	int __ret = 0;						\
	int __rc = 0;						\
								\
	if (!(cond)) {						\
		for (; __rc == 0;) {				\
			if (SCHEDULER_STOPPED())		\
				break;				\
			sleepq_lock(c);				\
			if (cond) {				\
				sleepq_release(c);		\
				__ret = 1;			\
				break;				\
			}					\
			sleepq_add(c, NULL, "completion",	\
				SLEEPQ_SLEEP, 0);		\
			sleepq_set_timeout(c,			\
				linux_timer_jiffies_until(end));\
			__rc = sleepq_timedwait(c, 0);		\
			if (__rc != 0)				\
				__ret = (cond);			\
		}						\
	} else {						\
		/* return remaining jiffies (at least 1) if the	\
		 * condition evaluated to TRUE before the 	\
		 * timeout elapsed.				\
		 */						\
		__ret = (end - jiffies);			\
		if( __ret < 1 )					\
			__ret = 1;				\
	}							\
	__ret;							\
})
#endif

#ifndef wait_event_interruptible_timeout
/*
 * This is left for backward compatibility with FreeBSD 10.3 and 11.0
 */
#define	wait_event_interruptible_timeout(q, cond, timeout)	\
({								\
	void *c = &(q).wchan;					\
	long end = jiffies + timeout;				\
	int __ret = 0;						\
	int __rc = 0;						\
								\
	if (!(cond)) {						\
		for (; __rc == 0;) {				\
			if (SCHEDULER_STOPPED())		\
				break;				\
			sleepq_lock(c);				\
			if (cond) {				\
				sleepq_release(c);		\
				__ret = 1;			\
				break;				\
			}					\
			sleepq_add(c, NULL, "completion",	\
				SLEEPQ_SLEEP | SLEEPQ_INTERRUPTIBLE, 0); \
			sleepq_set_timeout(c,			\
				linux_timer_jiffies_until(end));\
			__rc = sleepq_timedwait_sig(c, 0);	\
			if (__rc != 0)				\
				__ret = (cond);			\
		}						\
	} else {						\
		/* return remaining jiffies (at least 1) if the	\
		 * condition evaluated to TRUE before the 	\
		 * timeout elapsed.				\
		 */						\
		__ret = (end - jiffies);			\
		if( __ret < 1 )					\
			__ret = 1;				\
	}							\
	__ret;							\
})
#endif

#endif				/* _IW_IXL_LINUX_WAIT_H_ */
